/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.electric_motor;

import com.mrh0.createaddition.CreateAddition;
import com.mrh0.createaddition.blocks.electric_motor.ElectricMotorBlock;
import com.mrh0.createaddition.blocks.tesla_coil.TeslaCoil;
import com.mrh0.createaddition.compat.computercraft.Peripherals;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.transfer.EnergyTransferable;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class ElectricMotorTileEntity
extends GeneratingKineticTileEntity
implements EnergyTransferable {
    protected ScrollValueBehaviour generatedSpeed;
    protected final InternalEnergyStorage energy;
    private final LazyOptional<EnergyStorage> lazyEnergy;
    private boolean cc_update_rpm = false;
    private int cc_new_rpm = 32;
    private static final Integer RPM_RANGE = (Integer)Config.ELECTRIC_MOTOR_RPM_RANGE.get();
    private static final Integer DEFAULT_SPEED = 32;
    private static final Integer MIN_CONSUMPTION = (Integer)Config.ELECTRIC_MOTOR_MINIMUM_CONSUMPTION.get();
    private static final Integer STRESS = (Integer)Config.BASELINE_STRESS.get();
    private static final Long MAX_IN = (Long)Config.ELECTRIC_MOTOR_MAX_INPUT.get();
    private static final Long CAPACITY = (Long)Config.ELECTRIC_MOTOR_CAPACITY.get();
    private boolean active = false;
    int cc_antiSpam = 0;
    boolean first = true;

    public ElectricMotorTileEntity(class_2591<? extends ElectricMotorTileEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        long MAX_OUT = 0L;
        this.energy = new InternalEnergyStorage(CAPACITY, MAX_IN, MAX_OUT);
        this.lazyEnergy = LazyOptional.of(() -> this.energy);
        this.setLazyTickRate(20);
    }

    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        CenteredSideValueBoxTransform slot = new CenteredSideValueBoxTransform((motor, side) -> motor.method_11654((class_2769)ElectricMotorBlock.FACING) == side.method_10153());
        this.generatedSpeed = new ScrollValueBehaviour((class_2561)Lang.translateDirect((String)"generic.speed", (Object[])new Object[0]), (SmartTileEntity)this, (ValueBoxTransform)slot);
        this.generatedSpeed.between(-RPM_RANGE.intValue(), RPM_RANGE.intValue());
        this.generatedSpeed.value = DEFAULT_SPEED;
        this.generatedSpeed.scrollableValue = DEFAULT_SPEED;
        this.generatedSpeed.withUnit(i -> Lang.translateDirect((String)"generic.unit.rpm", (Object[])new Object[0]));
        this.generatedSpeed.withCallback(this::updateGeneratedRotation);
        this.generatedSpeed.withStepFunction(ElectricMotorTileEntity::step);
        behaviours.add((TileEntityBehaviour)this.generatedSpeed);
    }

    public static int step(ScrollValueBehaviour.StepContext context) {
        int current = context.currentValue;
        int step = 1;
        if (!context.shift) {
            int magnitude = Math.abs(current) - (context.forward == current > 0 ? 0 : 1);
            if (magnitude >= 4) {
                step *= 4;
            }
            if (magnitude >= 32) {
                step *= 4;
            }
            if (magnitude >= 128) {
                step *= 4;
            }
        }
        return step;
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = (float)STRESS.intValue() / 256.0f;
        return capacity;
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        tooltip.add((class_2561)class_2561.method_43470((String)"    ").method_10852((class_2561)class_2561.method_43471((String)"createaddition.tooltip.energy.consumption").method_27692(class_124.field_1080)));
        tooltip.add((class_2561)class_2561.method_43470((String)"    ").method_10852((class_2561)class_2561.method_43470((String)(" " + Util.format(ElectricMotorTileEntity.getEnergyConsumptionRate(this.generatedSpeed.getValue())) + "fe/t ")).method_27692(class_124.field_1075)).method_10852((class_2561)Lang.translateDirect((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).method_27692(class_124.field_1063)));
        return true;
    }

    public void updateGeneratedRotation(int i) {
        super.updateGeneratedRotation();
        this.cc_new_rpm = i;
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    public float getGeneratedSpeed() {
        if (!CABlocks.ELECTRIC_MOTOR.has(this.method_11010())) {
            return 0.0f;
        }
        return ElectricMotorTileEntity.convertToDirection((float)(this.active ? (float)this.generatedSpeed.getValue() : 0.0f), (class_2350)((class_2350)this.method_11010().method_11654((class_2769)ElectricMotorBlock.FACING)));
    }

    protected class_2248 getStressConfigKey() {
        return (class_2248)AllBlocks.WATER_WHEEL.get();
    }

    public InternalEnergyStorage getEnergyStorage() {
        return this.energy;
    }

    @Override
    @Nullable
    public EnergyStorage getEnergyStorage(@Nullable class_2350 side) {
        if (this.isEnergyInput(side) || this.isEnergyOutput(side)) {
            return (EnergyStorage)this.lazyEnergy.getValueUnsafer();
        }
        if (CreateAddition.CC_ACTIVE) {
            Peripherals.isPeripheral(this.method_10997(), this.method_11016(), side);
        }
        return null;
    }

    public boolean isEnergyInput(class_2350 side) {
        return side != this.method_11010().method_11654((class_2769)ElectricMotorBlock.FACING);
    }

    public boolean isEnergyOutput(class_2350 ignoredSide) {
        return false;
    }

    public void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.energy.read(compound);
        this.active = compound.method_10577("active");
    }

    public void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.energy.write(compound);
        compound.method_10556("active", this.active);
    }

    public void lazyTick() {
        super.lazyTick();
        this.cc_antiSpam = 5;
    }

    public static int getEnergyConsumptionRate(int rpm) {
        return Math.abs(rpm) > 0 ? (int)Math.max((double)((Integer)Config.FE_RPM.get()).intValue() * ((double)Math.abs(rpm) / 256.0), (double)MIN_CONSUMPTION.intValue()) : 0;
    }

    public void tick() {
        super.tick();
        if (this.first) {
            this.updateGeneratedRotation();
            this.first = false;
        }
        if (this.cc_update_rpm && this.cc_antiSpam > 0) {
            this.generatedSpeed.setValue(this.cc_new_rpm);
            this.cc_update_rpm = false;
            --this.cc_antiSpam;
            this.updateGeneratedRotation();
        }
        assert (this.field_11863 != null);
        if (this.field_11863.method_8608()) {
            return;
        }
        int con = ElectricMotorTileEntity.getEnergyConsumptionRate(this.generatedSpeed.getValue());
        if (!this.active) {
            if (this.energy.getAmount() > (long)con * 2L && !((Boolean)this.method_11010().method_11654((class_2769)ElectricMotorBlock.POWERED)).booleanValue()) {
                this.active = true;
                this.updateGeneratedRotation();
            }
        } else {
            long ext = this.energy.internalConsumeEnergy(con);
            if (ext < (long)con || ((Boolean)this.method_11010().method_11654((class_2769)ElectricMotorBlock.POWERED)).booleanValue()) {
                this.active = false;
                this.updateGeneratedRotation();
            }
        }
    }

    public int getDurationAngle(int deg, float initialProgress, float speed) {
        speed = Math.abs(speed);
        deg = Math.abs(deg);
        if (speed < 0.1f) {
            return 0;
        }
        double degreesPerTick = speed * 360.0f / 60.0f / 20.0f;
        return (int)((double)((1.0f - initialProgress) * (float)deg) / degreesPerTick + 1.0);
    }

    public int getDurationDistance(int dis, float initialProgress, float speed) {
        speed = Math.abs(speed);
        dis = Math.abs(dis);
        if (speed < 0.1f) {
            return 0;
        }
        double metersPerTick = speed / 512.0f;
        return (int)((double)((1.0f - initialProgress) * (float)dis) / metersPerTick);
    }

    public boolean setRPM(int rpm) {
        this.cc_new_rpm = rpm = Math.max(Math.min(rpm, RPM_RANGE), -RPM_RANGE.intValue());
        this.cc_update_rpm = true;
        return this.cc_antiSpam > 0;
    }

    public int getRPM() {
        return this.cc_new_rpm;
    }

    public int getGeneratedStress() {
        return (int)this.calculateAddedStressCapacity();
    }

    public int getEnergyConsumption() {
        return ElectricMotorTileEntity.getEnergyConsumptionRate(this.generatedSpeed.getValue());
    }

    public boolean isPoweredState() {
        return (Boolean)this.method_11010().method_11654((class_2769)TeslaCoil.POWERED);
    }
}

